/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.encased;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.content.contraptions.relays.elementary.SimpleKineticTileEntity;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EncasedCogwheelBlock
extends RotatedPillarKineticBlock
implements ICogWheel,
ITE<SimpleKineticTileEntity>,
ISpecialBlockItemRequirement {
    public static final BooleanProperty TOP_SHAFT = BooleanProperty.m_61465_((String)"top_shaft");
    public static final BooleanProperty BOTTOM_SHAFT = BooleanProperty.m_61465_((String)"bottom_shaft");
    boolean isLarge;
    private BlockEntry<CasingBlock> casing;

    public static EncasedCogwheelBlock andesite(boolean large, BlockBehaviour.Properties properties) {
        return new EncasedCogwheelBlock(large, properties, AllBlocks.ANDESITE_CASING);
    }

    public static EncasedCogwheelBlock brass(boolean large, BlockBehaviour.Properties properties) {
        return new EncasedCogwheelBlock(large, properties, AllBlocks.BRASS_CASING);
    }

    public EncasedCogwheelBlock(boolean large, BlockBehaviour.Properties properties, BlockEntry<CasingBlock> casing) {
        super(properties);
        this.isLarge = large;
        this.casing = casing;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP_SHAFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_SHAFT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{TOP_SHAFT, BOTTOM_SHAFT}));
    }

    public void m_49811_(CreativeModeTab pTab, NonNullList<ItemStack> pItems) {
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (target instanceof BlockHitResult) {
            return ((BlockHitResult)target).m_82434_().m_122434_() != this.getRotationAxis(state) ? (this.isLarge ? AllBlocks.LARGE_COGWHEEL.asStack() : AllBlocks.COGWHEEL.asStack()) : this.getCasing().asStack();
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState placedOn = context.m_43725_().m_8055_(context.m_8083_().m_142300_(context.m_43719_().m_122424_()));
        BlockState stateForPlacement = super.m_5573_(context);
        if (ICogWheel.isSmallCog(placedOn)) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)AXIS, (Comparable)((IRotate)placedOn.m_60734_()).getRotationAxis(placedOn));
        }
        return stateForPlacement;
    }

    public BlockEntry<CasingBlock> getCasing() {
        return this.casing;
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pState.m_60734_() == pAdjacentBlockState.m_60734_() && pState.m_61143_((Property)AXIS) == pAdjacentBlockState.m_61143_((Property)AXIS);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_().m_122434_() != state.m_61143_((Property)AXIS)) {
            return super.onWrenched(state, context);
        }
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        KineticTileEntity.switchToBlockState(level, pos, (BlockState)state.m_61122_((Property)(context.m_43719_().m_122421_() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT)));
        this.playRotateSound(level, pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)state));
        KineticTileEntity.switchToBlockState(context.m_43725_(), context.m_8083_(), (BlockState)(this.isLarge ? AllBlocks.LARGE_COGWHEEL : AllBlocks.COGWHEEL).getDefaultState().m_61124_((Property)AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)AXIS))));
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == state.m_61143_((Property)AXIS) && (Boolean)state.m_61143_((Property)(face.m_122421_() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT)) != false;
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (newState.m_60734_() instanceof EncasedCogwheelBlock && oldState.m_60734_() instanceof EncasedCogwheelBlock) {
            if (newState.m_61143_((Property)TOP_SHAFT) != oldState.m_61143_((Property)TOP_SHAFT)) {
                return false;
            }
            if (newState.m_61143_((Property)BOTTOM_SHAFT) != oldState.m_61143_((Property)BOTTOM_SHAFT)) {
                return false;
            }
        }
        return super.areStatesKineticallyEquivalent(oldState, newState);
    }

    @Override
    public boolean isSmallCog() {
        return !this.isLarge;
    }

    @Override
    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), worldIn, pos, (Direction.Axis)state.m_61143_((Property)AXIS));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)AXIS);
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        return ItemRequirement.of(this.isLarge ? AllBlocks.LARGE_COGWHEEL.getDefaultState() : AllBlocks.COGWHEEL.getDefaultState(), te);
    }

    @Override
    public Class<SimpleKineticTileEntity> getTileEntityClass() {
        return SimpleKineticTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends SimpleKineticTileEntity> getTileEntityType() {
        return this.isLarge ? (BlockEntityType)AllTileEntities.ENCASED_LARGE_COGWHEEL.get() : (BlockEntityType)AllTileEntities.ENCASED_COGWHEEL.get();
    }
}

